rule Win32_Ransomware_Prometey : tc_detection malicious
{
    meta:

        author              = "ReversingLabs"

        source              = "ReversingLabs"
        status              = "RELEASED"
        sharing             = "TLP:WHITE"
        category            = "MALWARE"
        malware             = "PROMETEY"
        description         = "Yara rule that detects Prometey ransomware."

        tc_detection_type   = "Ransomware"
        tc_detection_name   = "Prometey"
        tc_detection_factor = 5

    strings:

        $remote_connection_p1 = {
            55 8D AC 24 ?? ?? ?? ?? 81 EC ?? ?? ?? ?? 6A ?? 68 ?? ?? ?? ?? 64 A1 ?? ?? ?? ?? 50
            81 EC ?? ?? ?? ?? A1 ?? ?? ?? ?? 33 C5 89 85 ?? ?? ?? ?? 53 56 57 50 8D 45 ?? 64 A3
            ?? ?? ?? ?? 6A ?? 5E 8D 85 ?? ?? ?? ?? 89 75 ?? 50 BA ?? ?? ?? ?? 8D 4D ?? E8 ?? ??
            ?? ?? C6 45 ?? ?? C7 04 24 ?? ?? ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4
            ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? 51 8B C8 E8 ?? ?? ?? ?? 50 8D 4D ?? E8 ?? ?? ?? ??
            68 ?? ?? ?? ?? 8D 45 ?? C6 45 ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ??
            8D 8D ?? ?? ?? ?? C6 45 ?? ?? 51 8B C8 E8 ?? ?? ?? ?? 50 8D 4D ?? E8 ?? ?? ?? ?? 68
            ?? ?? ?? ?? 8D 45 ?? C6 45 ?? ?? 50 8D 45 ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 8D ?? ??
            ?? ?? C6 45 ?? ?? 51 8B C8 E8 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 4D
            ?? E8 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 4D ??
            E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A ?? 5B 8D 4D ?? 88 5D ?? E8 ?? ??
            ?? ?? 39 9D ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 8B 85 ?? ?? ?? ?? 0F 43 8D ?? ?? ?? ?? 03
            C1 39 9D ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? 0F 43 8D ?? ?? ?? ?? 51 50 51 8D 8D ?? ?? ??
            ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? C6 45 ?? ?? 50 8D 95 ?? ?? ?? ?? 8D 4D ?? E8 ??
            ?? ?? ?? 59 8D 8D ?? ?? ?? ?? C6 45 ?? ?? 51 8B C8 E8 ?? ?? ?? ?? 50 8D 8D ?? ?? ??
            ?? E8 ?? ?? ?? ?? 8D 4D ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 39 9D ?? ?? ?? ?? 8D 8D ?? ??
            ?? ?? 8B 85 ?? ?? ?? ?? 0F 43 8D ?? ?? ?? ?? 03 C1 39 9D ?? ?? ?? ?? 8D 8D ?? ?? ??
            ?? 0F 43 8D ?? ?? ?? ?? 51 50 51 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 85
            ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 43 85 ?? ?? ?? ?? 33 DB 53 53 53 53 50 88 5D
        }

        $remote_connection_p2 = {
            FF 15 ?? ?? ?? ?? 89 45 ?? 85 C0 0F 84 ?? ?? ?? ?? 6A ?? 53 56 53 53 6A ?? 68 ?? ??
            ?? ?? 50 FF 15 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 8B D8 85 DB 74 ?? 6A ?? 68 ?? ?? ?? ??
            33 C0 50 50 50 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 53 FF 15 ?? ?? ?? ?? 8B F0 85 F6 74 ??
            33 C0 50 50 50 50 56 FF 15 ?? ?? ?? ?? 85 C0 74 ?? 68 ?? ?? ?? ?? 8D 45 ?? 6A ?? 50
            E8 ?? ?? ?? ?? 51 8D 4D ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 83 7D ?? ?? 0F 85 ?? ?? ?? ??
            8D 4D ?? E8 ?? ?? ?? ?? 56 FF D7 53 FF D7 FF 75 ?? FF D7 80 7D ?? ?? 74 ?? 68 ?? ??
            ?? ?? E8 ?? ?? ?? ?? 59 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ??
            ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ??
            ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ??
            ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D ?? 64 89 0D ?? ?? ?? ?? 59 5F 5E 5B 8B 8D
            ?? ?? ?? ?? 33 CD E8 ?? ?? ?? ?? 81 C5 ?? ?? ?? ?? C9 C3 8B 85 ?? ?? ?? ?? 85 C0 0F
            84 ?? ?? ?? ?? 3D ?? ?? ?? ?? 73 ?? 8D 95 ?? ?? ?? ?? C6 84 05 ?? ?? ?? ?? ?? 8D 4D
            ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 85 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ??
            50 56 FF 15 ?? ?? ?? ?? 85 C0 75 ?? E9 ?? ?? ?? ?? E8
        }

        $find_files_p1 = {
            68 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5D ?? 8D 8D ?? ?? ?? ?? 68 ?? ?? ??
            ?? BA ?? ?? ?? ?? 89 9D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 ?? ?? 8D 4D ?? 8B D3 C7 04
            24 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C6 45 ?? ?? 8D 8D ?? ?? ?? ?? 83 7D ?? ?? 8D 45 ??
            51 0F 43 45 ?? 50 FF 15 ?? ?? ?? ?? 8B D8 89 9D ?? ?? ?? ?? 83 FB ?? 0F 84 ?? ?? ??
            ?? 33 C0 8D 7D ?? AB AB AB 33 C0 89 45 ?? 89 45 ?? 89 45 ?? C6 45 ?? ?? F6 85 ?? ??
            ?? ?? ?? 74 ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ??
            ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 ?? ?? ??
            ?? 8D 85 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 8B 95 ?? ?? ?? ?? 8D
            8D ?? ?? ?? ?? 68 ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 59 8B D0 C6 45 ?? ?? 8B 4A
            ?? 8B 7A ?? 2B CF 39 4E ?? 76 ?? 8B 46 ?? 2B 46 ?? 3B C7 72 ?? 83 7A ?? ?? 72 ?? 8B
            12 57 52 51 8B CE E8 ?? ?? ?? ?? EB ?? 56 8B CA E8 ?? ?? ?? ?? 50 8D 4D ?? E8 ?? ??
            ?? ?? C6 85 ?? ?? ?? ?? ?? 8D 45 ?? FF B5 ?? ?? ?? ?? 8D 4D ?? 50 E8 ?? ?? ?? ?? 8D
            4D ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ??
            E8 ?? ?? ?? ?? 83 7D ?? ?? 8D 4D ?? 8B 45 ?? 0F 43 4D ?? 8D 04 41 8D 4D ?? 0F 43 4D
            ?? 51 50 51 8D 4D ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 8D ?? ?? ?? ?? 83 7D ?? ?? 8D 7D
            ?? 8B 9D ?? ?? ?? ?? 0F 43 8D ?? ?? ?? ?? 83 7D ?? ?? 8B 45 ?? 0F 43 7D ?? 89 8D ??
            ?? ?? ?? 3B D8 77 ?? 85 DB 75 ?? 8B F3 EB ?? 0F BE 09 2B C3 40 89 8D ?? ?? ?? ?? 03
        }

        $find_files_p2 = {
            C7 89 85 ?? ?? ?? ?? 2B C7 50 51 57 EB ?? 53 FF B5 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83
            C4 ?? 85 C0 74 ?? 8B 85 ?? ?? ?? ?? 46 2B C6 50 FF B5 ?? ?? ?? ?? 56 E8 ?? ?? ?? ??
            8B F0 83 C4 ?? 85 F6 75 ?? 83 CE ?? 33 DB 56 BA ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ??
            ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 8D 45 ?? 89 5D ?? 50 8D 4D ?? 89 5D
            ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 7D ?? 83 7D ?? ?? 8B 55 ?? 0F 43 7D ?? 85 D2 74 ??
            83 C9 ?? 8D 42 ?? 3B C1 0F 42 C8 03 CF EB ?? 2B F7 EB ?? 3B CF 74 ?? 49 80 39 ?? 75
            ?? 2B CF EB ?? 83 C9 ?? 83 F9 ?? 0F 84 ?? ?? ?? ?? 8D 79 ?? 89 5D ?? C7 45 ?? ?? ??
            ?? ?? 88 5D ?? 3B D7 0F 82 ?? ?? ?? ?? 2B D7 8D 45 ?? 83 C9 ?? 83 FA ?? 0F 42 CA 83
            7D ?? ?? 51 0F 43 45 ?? 8D 4D ?? 03 C7 50 E8 ?? ?? ?? ?? 83 EC ?? C6 45 ?? ?? 8B CC
            8D 45 ?? 50 89 59 ?? 89 59 ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 ?? 83 F8 ?? 0F 85
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 53 50 E8 ?? ?? ?? ?? 59 59 8D 8D ?? ??
            ?? ?? E8 ?? ?? ?? ?? 51 51 8D 45 ?? C6 45 ?? ?? 50 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ??
            6A ?? 53 53 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 50 8D 8D ?? ?? ?? ??
            E8 ?? ?? ?? ?? BB ?? ?? ?? ?? 8B 78 ?? 03 38 3B FB 7D ?? 81 FE ?? ?? ?? ?? 76 ?? 8D
        }

        $find_files_p3 = {
            4D ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B FB 7D ?? 81 FE ?? ?? ?? ??
            76 ?? 8D 4D ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 4D ?? C6 45 ?? ??
            E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 6A ?? 8D 85 ?? ?? ?? ?? 53 50 E8 ?? ?? ?? ?? 83 C4 ??
            8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 4D ?? 83 7D ?? ?? 8B 45 ?? 0F 43 4D
            ?? 8D 04 41 50 51 8D 45 ?? 50 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? C6 45
            ?? ?? 56 BA ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? C7 04 24 ?? ??
            ?? ?? 50 8D 85 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 50 8D 4D ?? C6 45 ?? ?? E8 ??
            ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ??
            ?? BA ?? ?? ?? ?? B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 55 ?? 8B C8 E8 ?? ?? ?? ?? 50 E8
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? 53 50 E8 ?? ?? ?? ?? 83 C4 ?? 8D 8D ??
            ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? 8D 45 ?? 83 7D ?? ?? 51 0F 43 45 ?? 51 50 8D 8D
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 BD ?? ?? ?? ?? ?? 0F 84 ?? ?? ?? ?? 56 BA ?? ?? ?? ??
            8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? C6 45 ?? ?? C7 04 24 ?? ?? ?? ?? 50 8D 85 ?? ?? ??
            ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 56 8B C8 C6 45 ?? ?? E8 ?? ?? ?? ?? 50 8D 8D ?? ?? ??
            ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? C6 45 ?? ?? 50 8D 85
        }

        $find_files_p4 = {
            50 E8 ?? ?? ?? ?? 83 C4 ?? 68 ?? ?? ?? ?? 8B C8 C6 45 ?? ?? E8 ?? ?? ?? ?? 50 8D 8D
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 85 ?? ?? ?? ?? C6 45 ?? ?? 50 8D 85 ??
            ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 ?? 8B D0 C6 45 ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ??
            ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ??
            ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ??
            8D 8D ?? ?? ?? ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 8D
            ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8D 8D ?? ?? ?? ?? C6 45 ?? ?? E8
            ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? F6 85 ?? ?? ?? ?? ?? 74 ?? 8B 45
            ?? 8D 4D ?? 51 3B 45 ?? 74 ?? 8B C8 E8 ?? ?? ?? ?? 83 45 ?? ?? EB ?? 50 8D 4D ?? E8
            ?? ?? ?? ?? 8D 4D ?? E8 ?? ?? ?? ?? 8D 4D ?? C6 45 ?? ?? E8 ?? ?? ?? ?? 8B 9D ?? ??
            ?? ?? 8D 85 ?? ?? ?? ?? 50 53 FF 15 ?? ?? ?? ?? 85 C0 0F 85 ?? ?? ?? ?? 53 FF 15 ??
            ?? ?? ?? 8B 7D ?? 8B 75 ?? 6A ?? 5B 3B F7 74 ?? 56 E8 ?? ?? ?? ?? 03 F3 59 3B F7 75
            ?? 8B 7D ?? 8B 75 ?? 85 F6 74 ?? 3B F7 74 ?? 8B CE E8 ?? ?? ?? ?? 03 F3 3B F7 75 ??
            8B 75 ?? 8B 45 ?? 2B C6 99 F7 FB 6B C0 ?? 50 56 E8 ?? ?? ?? ?? 59 59 8D 4D ?? E8 ??
            ?? ?? ?? 8D 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C3
        }

        $encrypt_files = {
            8B FF 55 8B EC 57 FF 75 ?? E8 ?? ?? ?? ?? 59 8B 4D ?? 8B F8 8B 49 ?? 90 F6 C1 ?? 75
            ?? E8 ?? ?? ?? ?? C7 00 ?? ?? ?? ?? 8B 45 ?? 6A ?? 59 83 C0 ?? F0 09 08 83 C8 ?? E9
            ?? ?? ?? ?? 8B 45 ?? 8B 40 ?? 90 C1 E8 ?? A8 ?? 74 ?? E8 ?? ?? ?? ?? C7 00 ?? ?? ??
            ?? EB ?? 8B 45 ?? 8B 40 ?? 90 A8 ?? 74 ?? FF 75 ?? E8 ?? ?? ?? ?? 59 8B 4D ?? 83 61
            ?? ?? 84 C0 8B 45 ?? 74 ?? 8B 48 ?? 89 08 8B 45 ?? 6A ?? 59 83 C0 ?? F0 21 08 8B 45
            ?? 53 6A ?? 5B 83 C0 ?? F0 09 18 8B 45 ?? 6A ?? 59 83 C0 ?? F0 21 08 8B 45 ?? 83 60
            ?? ?? 8B 45 ?? 8B 40 ?? 90 A9 ?? ?? ?? ?? 75 ?? 56 8B 75 ?? 6A ?? E8 ?? ?? ?? ?? 59
            3B F0 74 ?? 8B 75 ?? 53 E8 ?? ?? ?? ?? 59 3B F0 75 ?? 57 E8 ?? ?? ?? ?? 59 85 C0 75
            ?? FF 75 ?? E8 ?? ?? ?? ?? 59 5E FF 75 ?? 8B 5D ?? 53 E8 ?? ?? ?? ?? 59 59 84 C0 75
            ?? 8B 45 ?? 6A ?? 59 83 C0 ?? F0 09 08 83 C8 ?? EB ?? 0F B6 C3 5B 5F 5D C3
        }

    condition:
        uint16(0) == 0x5A4D and
        (
            all of ($find_files_p*)
        ) and
        (
            $encrypt_files
        ) and
        (
            all of ($remote_connection_p*)
        )
}